------------------------------------------------------------------------------
-- List Footage, Revision: 2.0 
--
-- comp script
--
-- This script outputs a list of all footage used in the flow (Loaders and Savers)
--
-- written by : Isaac Guenard (izyk@eyeonline.com)
-- written    : Sept. 05, 2003
-- updated : Sept 27, 2005
-- changes : updated for 5
------------------------------------------------------------------------------



print()
print("Show footage used by loaders in this flow.")
print("----------------------------------------------")
print()

lds = composition:GetToolList(false, "Loader")

if table.getn(lds) > 0 then
	for i, tool in pairs(lds) do
		for i, clip in pairs(tool:GetAttrs().TOOLST_Clip_Name) do
			print(clip)
		end
	end
else
	print("No Loaders")
end


print()
print("Show footage used by savers in this flow.")
print("----------------------------------------------")
print()

svs = composition:GetToolList(false, "Saver")
if table.getn(svs) > 0 then 
	for i, tool in pairs(svs) do
		print(tool.Clip[TIME_UNDEFINED])
	end
else
	print("No Savers")
end

print()
print("----------------------------------------------")


